--[[ moonlight system direction ]]

-- this file is separated into multiple parts.

--[[ hardcoded ]]

-- GetAutoSetStyle()
-- dilemma 1: Do we make this hard flexible (on/off),
-- soft flexible (per-gametype), or hardcoded like it is now?

AutoSetStyleTable = {
	dance = false,
	pump = true,
	kb7	 = false, -- (only one style)
	ez2 = false, -- from looking elsewhere
	para = false, -- (only one style)
	ds3ddx = false, -- (only one style)
	beat = false,
	maniax = false, -- this is a guess, too lazy to boot mame
	techno = true, -- (even during gameplay! but not in StepMania.)
	popn = false
};

-- GetComboThresholds()
ComboThresholdTable = {
	dance = { Maintain = "TapNoteScore_W3", Continue = GAMESTATE:GetPlayMode() == "PlayMode_Oni" and "TapNoteScore_W2" or "TapNoteScore_W3" },
	pump = { Maintain = "TapNoteScore_W4", Continue = "TapNoteScore_W4" },
	techno = { Maintain = "TapNoteScore_W3", Continue = "TapNoteScore_W3" },
	kb7 = { Maintain = "TapNoteScore_W4", Continue = "TapNoteScore_W4" },
	-- these values are chosen to match Deluxe's PARASTAR:
	para = { Maintain = "TapNoteScore_W5", Continue = "TapNoteScore_W3" },
};

function GetAutoSetStyle()
	local CurrentGame = string.lower( GAMESTATE:GetCurrentGame():GetName() );
	return AutoSetStyleTable[CurrentGame];
end;

function GetPenalizeTapScore()
	local CurrentGame = string.lower( GAMESTATE:GetCurrentGame():GetName() );
	return (CurrentGame == "beat" or CurrentGame == "popn") and true or false;
end;

function GetComboThreshold()
	local CurrentGame = string.lower( GAMESTATE:GetCurrentGame():GetName() );
	return ComboThresholdTable[CurrentGame];
end;

--[[ flexible / main ]]

--[[ flexible / option menu rows ]]